
require( "scripts/style.lua" );

SetPauseMenuCanShow(false);
SetConfirmExitCanShow(true);

bsize_x = 18
bsize_y = 28

MakeDialog
{
	Map
	{
		x = 0,
		y = 0,
		w = 800,
		h = 600,
		
		
		bx1  = 245 - bsize_x, by1  = 556 - bsize_y,
		bx2  = 280 - bsize_x, by2  = 556 - bsize_y,
		bx3  = 315 - bsize_x, by3  = 556 - bsize_y,
		bx4  = 350 - bsize_x, by4  = 556 - bsize_y,
		bx5  = 385 - bsize_x, by5  = 556 - bsize_y,
		bx6  = 420 - bsize_x, by6  = 556 - bsize_y,
		bx7  = 455 - bsize_x, by7  = 556 - bsize_y,
		bx8  = 490 - bsize_x, by8  = 556 - bsize_y,
		bx9  = 525 - bsize_x, by9  = 556 - bsize_y,
		bx10 = 560 - bsize_x, by10 = 556 - bsize_y,
        
        fire_off_x = 19, fire_off_y = 44,
		
		
		Bitmap
		{
		    name = "background",
		    --image = "map/background",
		    x = kCenter,
		    y = kCenter,
		    w = 800,
		    h = 600,

            Bitmap
            {
		        name = "cafe_flo",
		        image = "map/cafe_flo_dis",
		        x = 106,
		        y = 60,
            },

            Bitmap
            {
		        name = "cafe_darla",
		        image = "map/cafe_darla_dis",
		        x = 510,
		        y = 90,
            },

            Bitmap
            {
		        name = "cafe_italian",
		        image = "map/cafe_italian_dis",
		        x = 488,
		        y = 317,
            },

            Bitmap
            {
		        name = "cafe_japan",
		        image = "map/cafe_japan_dis",
		        x = 45,
		        y = 285,
            },

            Bitmap
            {
		        name = "cafe_flo_tv",
		        image = "map/cafe_flo_tv_dis",
		        x = 398,
		        y = kCenter - 219
            },

            Bitmap
            {
		        name = "cloud",
		        image = "map/cloud01",
		        x = 370,
		        y = 3,
            },

            BeginGroup(),
            SetStyle(CreateRadioButtonStyle(FloCafeButtonGraphics, NoButtonSound)),
            Button
            {
                name = "cafe_flo_button",
		        x = 108,
		        y = 60,
		        mask = "map/button_mask",
                command = function()
                        if (GetCurrGameMode() ~= 0) then
                            DoModal("scripts/panel_difficulty.lua");
                            SetCurrLevelNum(1);
                        else
                            ChooseRestaurant(1);
                        end
                    end
            },
            
            SetStyle(CreateRadioButtonStyle(DarlaCafeButtonGraphics, NoButtonSound)),
            Button
            {
                name = "cafe_darla_button",
		        x = 510,
		        y = 90,
		        mask = "map/button_mask1",
                command = function()
                        if (GetCurrGameMode() ~= 0) then
                            DoModal("scripts/panel_difficulty.lua");
                            SetCurrLevelNum(11);
                        else
                            ChooseRestaurant(2);
                        end
                    end
            },

            SetStyle(CreateRadioButtonStyle(ItalianCafeButtonGraphics, NoButtonSound)),
            Button
            {
                name = "cafe_italian_button",
		        x = 488,
		        y = 317,
		        mask = "map/button_mask",
                command = function()
                        if (GetCurrGameMode() ~= 0) then
                            DoModal("scripts/panel_difficulty.lua");
                            SetCurrLevelNum(21);
                        else
                            ChooseRestaurant(3);
                        end
                    end
            },

            SetStyle(CreateRadioButtonStyle(JapanCafeButtonGraphics, NoButtonSound)),
            Button
            {
                name = "cafe_japan_button",
		        x = 45,
		        y = 285,
		        mask = "map/button_mask",
                command = function()
                        if (GetCurrGameMode() ~= 0) then
                            DoModal("scripts/panel_difficulty.lua");
                            SetCurrLevelNum(31);
                        else
                            ChooseRestaurant(4);
                        end
                    end
            },

            SetStyle(CreateRadioButtonStyle(FloTVCafeButtonGraphics, NoButtonSound)),
            Button
            {
                name = "cafe_flo_tv_button",
		        x = 398,
		        y = kCenter - 219,
		        mask = "map/button_mask2",
                command = function()
                        if (GetCurrGameMode() ~= 0) then
                            DoModal("scripts/panel_difficulty.lua");
                            SetCurrLevelNum(41);
                        else
                            ChooseRestaurant(5);
                        end
                    end
            },

            SetStyle(CreatePushButtonStyle(MapStartButtonGraphics, DefaultButtonSound)),
            Button
            {
                name = "play",
                x = 590, y = 538,
                command = function()
                        SetCurrLevelNum(GetCurrLevelNum());
                        if (GetCurrLevelNum() > 1)
                        then
                            --SwapToModal("scripts/sh_shop_loop.lua");
                            --SwapToModal("scripts/cd_game_loop.lua");
                            SetLoadPart(2); -- load game
                            SwapToModal("scripts/loader.lua");
                        else
                            StartComicsTimer();
                            SwapToModal("scripts/comic_1_1.lua");
                        end
                    end,
                SetStyle(CreateTextStyle(FontButtons, 34, WhiteColorAlpha128)),
                CreateTextLeftAlign(30,7,"start",2,2),
                SetStyle(CreateTextStyle(FontButtons, 34, BlackColor)),
                CreateTextLeftAlign(30,7,"start",0,0),
            },

            SetStyle(CreatePushButtonStyle(MapBackButtonGraphics, DefaultButtonSound)),
            Button
            {
                name = "mainmenu",
                x = 710, y = 546,
                command = function() QuitToMainMenu(); end,
         		SetStyle(CreateTextStyle(FontButtons, 24, WhiteColorAlpha128)),
                CreateText(2,2,"back",7,0),
				SetStyle(CreateTextStyle(FontButtons, 24, BlackColor)),
        	    CreateText(0,0,"back",7,0),
            },
            --story mode: scores and restaurant name
            SetStyle(CreateTextStyle(FontGame, 23, WhiteColor)),
            Text
            {
                name="cafe_name_st_shadow",
			    flags=kVAlignCenter+kHAlignCenter,
			    x = 44, y = 486,
				w=180,h=kMax,
            },
            SetStyle(CreateTextStyle(FontGame, 23, BlackColor)),
            Text
            {
                name="cafe_name_st",
			    flags=kVAlignCenter+kHAlignCenter,
			    x = 42, y = 484,
				w=180,h=kMax,
            },
            
            SetStyle(CreateTextStyle(FontGame, 20, WhiteColor)),
            Text
            {
                name="bestscore_shadow",
			    flags=kVAlignCenter+kHAlignCenter,
			    x = 54, y = 537,
				w=160,h=kMax,
            },
            SetStyle(CreateTextStyle(FontGame, 20, BlackColor)),
            Text
            {
                name="bestscore",
			    flags=kVAlignCenter+kHAlignCenter,
			    x = 52, y = 535,
				w=160,h=kMax,
            },

            SetStyle(CreateTextStyle(FontGame, 17, WhiteColor)),
            Text
            {
                name="customerslost_shadow",
			    flags=kVAlignCenter+kHAlignCenter,
			    x = 54, y = 577,
				w=160,h=kMax,
            },
            SetStyle(CreateTextStyle(FontGame, 17, BlackColor)),
            Text
            {
                name="customerslost",
			    flags=kVAlignCenter+kHAlignCenter,
			    x = 52, y = 575,
				w=160,h=kMax,
            },
            --endless mode: cafe name and score
            SetStyle(CreateTextStyle(FontGame, 26, WhiteColor)),
            Text
            {
                name="cafe_name_shadow",
			    flags=kVAlignCenter+kHAlignCenter,
			    x = 252, y = 506,
				w=300,h=kMax,
            },
            SetStyle(CreateTextStyle(FontGame, 26, BlackColor)),
            Text
            {
                name="cafe_name",
			    flags=kVAlignCenter+kHAlignCenter,
			    x = 250, y = 504,
				w=300,h=kMax,
            },

            SetStyle(CreateTextStyle(FontGame, 17, WhiteColor)),
            Text
            {
                name="endless_easy_score_shadow",
			    flags=kVAlignCenter+kHAlignCenter,
			    x = 202, y = 564,
				w=160,h=kMax,
            },
            SetStyle(CreateTextStyle(FontGame, 17, BlackColor)),
            Text
            {
                name="endless_easy_score",
			    flags=kVAlignCenter+kHAlignCenter,
			    x = 200, y = 562,
				w=160,h=kMax,
            },
            SetStyle(CreateTextStyle(FontGame, 17, WhiteColor)),
            Text
            {
                name="endless_normal_score_shadow",
			    flags=kVAlignCenter+kHAlignCenter,
			    x = 302, y = 564,
				w=160,h=kMax,
            },
            SetStyle(CreateTextStyle(FontGame, 17, BlackColor)),
            Text
            {
                name="endless_normal_score",
			    flags=kVAlignCenter+kHAlignCenter,
			    x = 300, y = 562,
				w=160,h=kMax,
            },
            SetStyle(CreateTextStyle(FontGame, 17, WhiteColor)),
            Text
            {
                name="endless_hard_score_shadow",
			    flags=kVAlignCenter+kHAlignCenter,
			    x = 402, y = 564,
				w=160,h=kMax,
            },
            SetStyle(CreateTextStyle(FontGame, 17, BlackColor)),
            Text
            {
                name="endless_hard_score",
			    flags=kVAlignCenter+kHAlignCenter,
			    x = 400, y = 562,
				w=160,h=kMax,
            },
            
        },
    },
}
